/**
 * 文件名： StatRequestLog.java 此类描述的是： 作者: sunjiangrong 创建时间: 2016年4月26日 上午11:48:19
 */
package cn.com.duiba.tuia.log;

import cn.com.duiba.boot.perftest.PerfTestContext;
import cn.com.duiba.tuia.enums.CatGroupEnum;
import cn.com.duiba.tuia.service.filter.impl.AutoFlowbackFilterImpl;
import cn.com.duiba.tuia.tool.CatUtil;
import cn.com.duiba.tuia.utils.DESUtil;
import cn.com.duiba.tuia.utils.MD5;
import cn.com.tuia.advert.model.ObtainAdvertReq;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;

/**
 * 请求结果日志记录格式 <功能详细描述>
 * 
 * @author: sunjiangrong
 * @创建时间: 2016年4月26日 上午11:48:19
 * @version:
 */
public final class StatRequestJsonLog extends BaseInnerLog{
    
    /** The logger. 
     * @param req */

    public static void log(ObtainAdvertReq req) {

        // 请求数监控
        if (AutoFlowbackFilterImpl.isAutoFlowback(req.getLogExtExpMap())) {
            //自动回流请求（刷量）
            CatUtil.log(CatGroupEnum.CAT_108001.getCode());
        }else {
            //正常的请求日志答应
            CatUtil.log(CatGroupEnum.CAT_101_REQ.getCode());
        }
        if(PerfTestContext.isCurrentInPerfTestMode())return;
        //发券接口防刷 校验是否是正常访问
        checkNormalVisit(req);
        req.setAdvertNewVal(null);
        req.setAdvertMdVal(null);
        Long slotId = setSlotIdToNull(req);
        String json = format(req);
        BaseInnerLog.log(json, BaseInnerLog.ADVERT_INNER_LOG_REQUEST, req.getTime());
        req.setSlotId(slotId);
    }

    //发券接口防刷 校验是否是正常访问
    private static void checkNormalVisit(ObtainAdvertReq req){
        try{
            req.setAntiBrushType(1);//默认非法
            if(StringUtils.isBlank(req.getAdvertNewVal()) || StringUtils.isBlank(req.getAdvertMdVal()))return;
            StringBuilder desVal=new StringBuilder();
            desVal.append(req.getDeviceId()).append(req.getConsumerId()).append(req.getSlotId()).append(req.getAppId()).append(req.getBeginTime());
            String advertMdVal=MD5.md5(desVal.toString());
            if(!advertMdVal.equals(req.getAdvertMdVal()))return;
            req.setAntiBrushType(0);//如果能够匹配，则为正常
        }catch(Exception e){

        }
    }

    private static String format(ObtainAdvertReq req) {
        return JSONObject.toJSONString(req);
    }

    /**
     * 虚拟发券请求日志
     *
     * @param req
     */
    public static void imitateLog(ObtainAdvertReq req) {

        // 请求数监控
        CatUtil.log(CatGroupEnum.CAT_106002.getCode());
        if(PerfTestContext.isCurrentInPerfTestMode()){
            return;
        }
        req.setAdvertNewVal(null);
        req.setAdvertMdVal(null);
        Long slotId = setSlotIdToNull(req);
        String json = format(req);
        ImitateBaseInnerLog.imitateLog(json, BaseInnerLog.ADVERT_INNER_LOG_REQUEST, req.getTime());
        req.setSlotId(slotId);
    }
}
