/**
 * 文件名： StatRequestLog.java 此类描述的是： 作者: sunjiangrong 创建时间: 2016年4月26日 上午11:48:19
 */
package cn.com.duiba.tuia.log;

import cn.com.duiba.boot.perftest.PerfTestContext;
import cn.com.tuia.advert.model.SpmlogReq;

import com.alibaba.fastjson.JSONObject;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

/**
 * 请求唯品会和接口返回结果的日志
 *
 * @创建时间: 2016年4月26日 上午11:48:19
 * @version:
 */
public final class VipRestApiLog extends BaseInnerLog {

    /**
     * The logger.
     */
    private static Logger log = LoggerFactory.getLogger(VipRestApiLog.class);

    public static void log(SpmlogReq req, String url, ResponseEntity<Object> responseEntity) {
        if (PerfTestContext.isCurrentInPerfTestMode()) return;
        vipVO vip = new vipVO();
        vip.setReq(req);
        vip.setUrl(url);
        vip.setResponseEntity(responseEntity);
        String json = JSONObject.toJSONString(vip);
        log.info(json);
        BaseInnerLog.log(json, BaseInnerLog.ADVERT_INNER_LOG_VIP_RESPONSE,req.getTime());
    }
    
    static class vipVO{
        private SpmlogReq req;
        
        private String url;
        
        private ResponseEntity<Object> responseEntity;

        
        public SpmlogReq getReq() {
            return req;
        }

        
        public void setReq(SpmlogReq req) {
            this.req = req;
        }

        
        public String getUrl() {
            return url;
        }

        
        public void setUrl(String url) {
            this.url = url;
        }

        
        public ResponseEntity<Object> getResponseEntity() {
            return responseEntity;
        }

        
        public void setResponseEntity(ResponseEntity<Object> responseEntity) {
            this.responseEntity = responseEntity;
        }
    }
}
