/**
 * Project Name:engine-service File Name:CheckPeriodIsPutMsgChannel.java Package Name:cn.com.duiba.tuia.message.channel
 * Date:2017年8月21日下午5:40:56 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.message.channel;

import cn.com.duiba.tuia.service.AdvertPeriodService;
import cn.com.tuia.advert.message.RedisMessageChannel;
import cn.com.tuia.advert.message.consumer.AbstractRedisMessageHandle;
import cn.com.tuia.advert.message.consumer.RedisMessageHandle;
import com.alibaba.fastjson.JSON;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;


@Component
@RedisMessageHandle(RedisMessageChannel.UPDATE_ADVERT_PERIOD)
public class PeriodsCacheMsgChannel extends AbstractRedisMessageHandle {

    @Autowired
    private AdvertPeriodService advertPeriodService;

    @Override
    public Runnable createHandle(RedisMessageChannel channel, String message) {

        return new Runnable() {

            @Override
            public void run() {
                logger.info(channel.getChannel() + ";msg=" + message);
                List<Long> periods = JSON.parseArray(message, Long.class);
                try {
                    advertPeriodService.invalidPeriodCache(periods);
                } catch (Exception e) {
                    logger.error("PeriodsCacheMsgChannel msg error msg[{}],exception:{}", message, e);
                }
            }
        };
    }

}
