package cn.com.duiba.tuia.message.channel;

import cn.com.duiba.tuia.cache.ActPreCache;
import cn.com.tuia.advert.message.RedisMessageChannel;
import cn.com.tuia.advert.message.consumer.AbstractRedisMessageHandle;
import cn.com.tuia.advert.message.consumer.RedisMessageHandle;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * Created by ZhangShun at 2020/5/22
 */
@Component
@RedisMessageHandle(RedisMessageChannel.UPDATE_ADVERT_MATERIAL_ACT_MSG)
public class UpdateAdvertActPreChannel extends AbstractRedisMessageHandle {

    @Autowired
    private ActPreCache actPreCache;

    @Override
    public Runnable createHandle(RedisMessageChannel channel, String message) {
        return () -> {
            logger.info(channel.getChannel() + ";msg=" + message);
            JSONObject jsonObject = JSONObject.parseObject(message);

            // 情况广告活动预发券素材缓存
            Long advertId = jsonObject.getLong("advertId");
            String newTrade = jsonObject.getString("newTrade");
            actPreCache.refresh(advertId, newTrade);
        };
    }
}
