/**
 * Project Name:engine-service
 * File Name:UpdateAdvertLimitingMsgChannel.java
 * Package Name:cn.com.duiba.tuia.message.channel
 * Date:2017年8月21日下午5:33:28
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.message.channel;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.com.duiba.tuia.domain.vo.MessageVO;
import cn.com.duiba.tuia.service.LimitingMaximunService;
import cn.com.tuia.advert.message.RedisMessageChannel;
import cn.com.tuia.advert.message.consumer.AbstractRedisMessageHandle;
import cn.com.tuia.advert.message.consumer.RedisMessageHandle;

/**
 * ClassName:UpdateAdvertLimitingMsgChannel <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2017年8月21日 下午5:33:28 <br/>
 * @author   zp
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Component
@RedisMessageHandle(RedisMessageChannel.UPDATE_ADVERT_LIMITING_MSG)
public class UpdateAdvertLimitingMsgChannel extends AbstractRedisMessageHandle{
    
    @Autowired
    private LimitingMaximunService maximunCacheService;

    @Override
    public Runnable createHandle(RedisMessageChannel channel, String message) {
        return new Runnable(){

            @Override
            public void run() {
                logger.info(channel.getChannel() + ";msg=" + message);
                MessageVO messageVO = MessageVO.createByJson(message,channel.getChannel());
                Long advertId = messageVO.getAdvertId();
                Long orientationPackageId = messageVO.getOrientationPackageId();
                Long appId = messageVO.getAppId();

                if (advertId == null || orientationPackageId == null) {
                    return;
                }
                //更新当天限流媒体是否达到峰值
                maximunCacheService.updateLimitingMaximunCache(advertId, orientationPackageId, appId);
            }
        };
    }

}

