/**
 * Project Name:engine-service
 * File Name:UpdateAdvertMsgChannel.java
 * Package Name:cn.com.duiba.tuia.message.channel
 * Date:2017年8月21日下午4:11:01
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.message.channel;

import java.util.List;

import cn.com.tuia.advert.model.messageDto.AdvertMsg;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSON;

import cn.com.duiba.tuia.cache.AdvertMapCacheManager;
import cn.com.duiba.tuia.cache.ServiceManager;
import cn.com.duiba.tuia.service.AdvertOrientationService;
import cn.com.tuia.advert.message.RedisMessageChannel;
import cn.com.tuia.advert.message.consumer.AbstractRedisMessageHandle;
import cn.com.tuia.advert.message.consumer.RedisMessageHandle;

/**
 * ClassName:UpdateAdvertMsgChannel <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2017年8月21日 下午4:11:01 <br/>
 * @author   zp
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Component
@RedisMessageHandle(RedisMessageChannel.UPDATE_ADVERTS_MSG)
public class UpdateAdvertMsgChannel extends AbstractRedisMessageHandle{
    

    @Autowired
    private AdvertMapCacheManager advertMapCacheManager;
    @Autowired
    private AdvertOrientationService orientationService;
    @Autowired
    private ServiceManager serviceManager;

    @Override
    public Runnable createHandle(RedisMessageChannel channel, String message) {
        return new Runnable(){
            @Override
            public void run() {
                logger.info(channel.getChannel() + ";msg=" + message);
                AdvertMsg uAdvertMsg = JSON.parseObject(message, AdvertMsg.class);
                int type = uAdvertMsg.getType();
                List<Long> ids = uAdvertMsg.getIds();

//                Integer advertType = uAdvertMsg.getAdvertType();
//                if (advertType != null && advertType != CommonConstant.HD_ADVERT_TYPE) {
//                    return;
//                }

                if (type == 0) {
                    advertMapCacheManager.initAllAdvertCache();
                    advertMapCacheManager.initAllValidAdvertFilterCache();
                } else if (type == 1) {
                    for (Long advertId : ids) {
                        advertMapCacheManager.updateAdvertCache(advertId);
                        //广告优惠券缓存
                        serviceManager.updateAdvertCouponCache(advertId);

                        advertMapCacheManager.updateValidAdvertFilterCache(advertId);
                        orientationService.updateDefaultOrientation(advertId);
                    }
                }
            }
        };
    }
}

