/**
 * Project Name:engine-service
 * File Name:UpdateAdvertPkgPutMsgChannel.java
 * Package Name:cn.com.duiba.tuia.message.channel
 * Date:2017年8月21日下午5:48:43
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.message.channel;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.com.duiba.tuia.cache.AdvertPkgPutFlagCacheService;
import cn.com.duiba.tuia.exception.TuiaException;
import cn.com.tuia.advert.message.RedisMessageChannel;
import cn.com.tuia.advert.message.consumer.AbstractRedisMessageHandle;
import cn.com.tuia.advert.message.consumer.RedisMessageHandle;

import java.text.ParseException;

/**
 * ClassName:UpdateAdvertPkgPutMsgChannel <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2017年8月21日 下午5:48:43 <br/>
 * @author   zp
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Component
@RedisMessageHandle(RedisMessageChannel.UPDATE_ADVERT_PKG_PUT_MSG)
public class UpdateAdvertPkgPutMsgChannel extends AbstractRedisMessageHandle{
    
    @Autowired
    private AdvertPkgPutFlagCacheService advertPkgPutFlagCacheService;

    @Override
    public Runnable createHandle(RedisMessageChannel channel, String message) {
        
        return new Runnable(){

            @Override
            public void run() {
                try {
                    logger.info(channel.getChannel() + ";msg=" + message);
                    advertPkgPutFlagCacheService.updateAdvertPkgPutFlag(message);
                } catch (TuiaException e) {
                    logger.error("redis msg updateAdvertPkgPutFlag error",e);
                } catch (ParseException e) {
                    logger.error("redis msg updateAdvertPkgPutFlag error ParseException",e);
                }
            }
        };
    }

}

