/**
 * Project Name:engine-service
 * File Name:UpdateAdvertTagMsgChannel.java
 * Package Name:cn.com.duiba.tuia.message.channel
 * Date:2017年8月21日下午5:46:10
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.message.channel;

import cn.com.duiba.tuia.cache.AdvertSupportPlanCacheManager;
import cn.com.tuia.advert.message.RedisMessageChannel;
import cn.com.tuia.advert.message.consumer.AbstractRedisMessageHandle;
import cn.com.tuia.advert.message.consumer.RedisMessageHandle;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Objects;

/**
 * created by ZhangShun at 2020-05-12.
 */
@Component
@RedisMessageHandle(RedisMessageChannel.UPDATE_ADVERT_SUPPORT_MSG)
public class UpdateAdvertSupportMsgChannel extends AbstractRedisMessageHandle{

    @Resource
    private AdvertSupportPlanCacheManager advertSupportPlanCacheManager;

    @Override
    public Runnable createHandle(RedisMessageChannel channel, String message) {
        return new Runnable(){

            @Override
            public void run() {
                logger.info(channel.getChannel() + ";msg=" + message);
                JSONObject jsonObject = JSONObject.parseObject(message);
                Long advertId = jsonObject.getLong("advertId");
                if (Objects.nonNull(advertId)) {
                    advertSupportPlanCacheManager.refresh();
                }
            }
        };
    }

}
