/**
 * Project Name:engine-service
 * File Name:UpdateAdvertTagMsgChannel.java
 * Package Name:cn.com.duiba.tuia.message.channel
 * Date:2017年8月21日下午5:46:10
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.message.channel;

import java.util.List;
import java.util.stream.Collectors;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.com.duiba.tuia.bo.AdvertBannedTagBo;
import cn.com.duiba.tuia.domain.vo.AdvertOrientationPackageVO;
import cn.com.duiba.tuia.domain.vo.MessageVO;
import cn.com.duiba.tuia.service.AdvertOrientationService;
import cn.com.duiba.tuia.service.ResourceTagsService;
import cn.com.tuia.advert.message.RedisMessageChannel;
import cn.com.tuia.advert.message.consumer.AbstractRedisMessageHandle;
import cn.com.tuia.advert.message.consumer.RedisMessageHandle;

/**
 * ClassName:UpdateAdvertTagMsgChannel <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2017年8月21日 下午5:46:10 <br/>
 * @author   zp
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Component
@RedisMessageHandle(RedisMessageChannel.UPDATE_ADVERT_TAG_MSG)
public class UpdateAdvertTagMsgChannel extends AbstractRedisMessageHandle{
    
    @Autowired
    private AdvertBannedTagBo advertBannedTagBo;

    @Autowired
    private ResourceTagsService resourceTagsService;

    @Autowired
    private AdvertOrientationService advertOrientationService;
    
    @Override
    public Runnable createHandle(RedisMessageChannel channel, String message) {
        return new Runnable(){

            @Override
            public void run() {
                logger.info(channel.getChannel() + ";msg=" + message);
                MessageVO messageVO = MessageVO.createByJson(message,channel.getChannel());
                Long advertId = messageVO.getAdvertId();
                Long orientationPackageId = messageVO.getOrientationPackageId();

                if (advertId == null) {
                    return;
                }
                
                if (orientationPackageId != null){
                    //将配置标签从缓存中移除
                    advertBannedTagBo.deleteBannedCacheByAdvertIdAndOrientataionPackageId(advertId,
                                                                                          orientationPackageId);
                }else {
                    //如果配置包ID为null，将广告下配置包的屏蔽标签为沿用的配置包标签缓存删除
                    List<AdvertOrientationPackageVO> listAdvertOrientationPackage = advertOrientationService.getOrientationList(advertId);
                    List<Long> listAdvertOrientationPackageIds = listAdvertOrientationPackage.stream()
                        .map(orientationPackage -> {
                            return orientationPackage.isDefaultOrientation() ? 0L: orientationPackage.getId();
                        }).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(listAdvertOrientationPackageIds)) {
                        return;
                    }
                    listAdvertOrientationPackageIds.forEach(packageId -> advertBannedTagBo.deleteBannedCacheByAdvertIdAndOrientataionPackageId(advertId, packageId));

                    resourceTagsService.refreshResourceCache(advertId);
                }
            }
        };
    }

}

