
package cn.com.duiba.tuia.message.channel;

import cn.com.duiba.tuia.api.TuiaMediaClientService;
import cn.com.tuia.advert.message.RedisMessageChannel;
import cn.com.tuia.advert.message.consumer.AbstractRedisMessageHandle;
import cn.com.tuia.advert.message.consumer.RedisMessageHandle;
import com.alibaba.fastjson.JSON;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
@RedisMessageHandle(RedisMessageChannel.MEDIA_SELECT_ADVERT)
public class UpdateMediaSelectAdvertMsgChannel extends AbstractRedisMessageHandle {

    @Autowired
    private TuiaMediaClientService tuiaMediaClientService;

    @Override
    public Runnable createHandle(RedisMessageChannel channel, String message) {
        return new Runnable() {
            @Override
            public void run() {
                logger.info(channel.getChannel() + ";msg=" + message);
                List<Long> slotMap = JSON.parseArray(message, Long.class);
                tuiaMediaClientService.refreshMediaSelectAdvertCache(slotMap);
            }
        };
    }

}

