/**
 * Project Name:engine-service
 * File Name:UpdateValidAdvertsMsgChannel.java
 * Package Name:cn.com.duiba.tuia.message.channel
 * Date:2017年8月21日下午5:29:58
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.message.channel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.com.duiba.tuia.cache.NewAppTestCacheService;
import cn.com.duiba.tuia.domain.model.UpdateNewAppTestCacheMsg;
import cn.com.tuia.advert.message.RedisMessageChannel;
import cn.com.tuia.advert.message.consumer.AbstractRedisMessageHandle;
import cn.com.tuia.advert.message.consumer.RedisMessageHandle;

import com.alibaba.fastjson.JSONObject;

/**
 * 
 * ClassName: UpdateNewAppTestCacheMsgChannel <br/>
 * Function: 新媒体试投缓存更新. <br/>
 * date: 2018年9月20日 下午8:24:39 <br/>
 *
 * @author chencheng
 * @version 
 * @since JDK 1.8
 */
@Component
@RedisMessageHandle(RedisMessageChannel.UPDATE_NEW_APP_TEST_CACHE_MSG)
public class UpdateNewAppTestCacheMsgChannel extends AbstractRedisMessageHandle{

    @Autowired
    private NewAppTestCacheService newAppTestCacheService;
    
    @Override
    public Runnable createHandle(RedisMessageChannel channel, String message) {
        return new Runnable(){
            @Override
            public void run() {
                logger.info(channel.getChannel() + ";msg=" + message);
                UpdateNewAppTestCacheMsg msgObj = JSONObject.parseObject(message, UpdateNewAppTestCacheMsg.class);

                if (msgObj.getAppId() == null || msgObj.getType() == null) {

                    logger.warn("媒体或type为空的情况下,message:{}", message);
                    return;
                }
                switch (msgObj.getType()) {
                    case UpdateNewAppTestCacheMsg.TYPE_NEW_APP_IDS_CACHE:
                        newAppTestCacheService.newAppIdsCacheRefresh();
                        break;
                    case UpdateNewAppTestCacheMsg.TYPE_APP_TEST_TO_ADVERT_CACHE:
                        break;
                    case UpdateNewAppTestCacheMsg.TYPE_NEW_APP_NOT_TEST_TRADE_CACHE:
                        newAppTestCacheService.newAppNotTestTradeCacheRefresh(msgObj.getAppId());
                            break;
                    case UpdateNewAppTestCacheMsg.TYPE_NEW_APP_NOT_TEST_ADVERT_CACHE:
                        newAppTestCacheService.newAppNotTestAdvertCacheRefresh(msgObj.getAppId());
                        break;
                    case UpdateNewAppTestCacheMsg.TYPE_NEW_APP_TEST_ALL_ADVERT_CACHE:
                        newAppTestCacheService.allTestAdvertCacheRefresh();
                        break;
                    case UpdateNewAppTestCacheMsg.TYPE_NEW_APP_TEST_ALL_ADVERT_CACHE_OTHER:
                        newAppTestCacheService.appTestToAdvertCacheRefresh(msgObj.getAdvertId());
                        break;
                    default:
                        break;
                }
                
            }

        };
    }
}

