/**
 * Project Name:engine-service
 * File Name:UpdatePeriodIsPutNewMsgChannel.java
 * Package Name:cn.com.duiba.tuia.message.channel
 * Date:2017年8月21日下午5:38:10
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.message.channel;

import java.util.HashMap;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSON;

import cn.com.duiba.tuia.service.AdvertPeriodService;
import cn.com.tuia.advert.message.RedisMessageChannel;
import cn.com.tuia.advert.message.consumer.AbstractRedisMessageHandle;
import cn.com.tuia.advert.message.consumer.RedisMessageHandle;

/**
 * ClassName:UpdatePeriodIsPutNewMsgChannel <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2017年8月21日 下午5:38:10 <br/>
 * @author   zp
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Component
@RedisMessageHandle(RedisMessageChannel.UPDATE_PERIOD_ISPUT_NEW_MSG)
public class UpdatePeriodIsPutNewMsgChannel extends AbstractRedisMessageHandle{
    
    @Autowired
    private AdvertPeriodService advertPeriodService;

    @Override
    public Runnable createHandle(RedisMessageChannel channel, String message) {
        return new Runnable(){
            @Override
            public void run() {
                @SuppressWarnings("unchecked")
                Map<String,Object> msg = JSON.parseObject(message, HashMap.class);
                logger.info(channel.getChannel() + ";msg=" + message);
                String key = (String) msg.get("key");
                Boolean flag = (Boolean) msg.get("value");
                advertPeriodService.setAdvertPeriodPut(key,flag);
            }
        };
    }

}

