/**
 * Project Name:engine-service
 * File Name:UpdatePrivilegeAdvertMsgChannel.java
 * Package Name:cn.com.duiba.tuia.message.channel
 * Date:2017年8月21日下午5:53:52
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.message.channel;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.com.duiba.tuia.service.AdvertPrivilegeService;
import cn.com.tuia.advert.message.RedisMessageChannel;
import cn.com.tuia.advert.message.consumer.AbstractRedisMessageHandle;
import cn.com.tuia.advert.message.consumer.RedisMessageHandle;

/**
 * ClassName:UpdatePrivilegeAdvertMsgChannel <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2017年8月21日 下午5:53:52 <br/>
 * @author   zp
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Component
@RedisMessageHandle(RedisMessageChannel.UPDATE_PRIVILEGE_ADVERT_MSG)
public class UpdatePrivilegeAdvertMsgChannel extends AbstractRedisMessageHandle{
    
    @Autowired
    private AdvertPrivilegeService advertPrivilegeService;

    @Override
    public Runnable createHandle(RedisMessageChannel channel, String message) {
        
        return new Runnable(){

            @Override
            public void run() {
              logger.info(channel.getChannel() + ";msg=" + message);
              //更新特权广告库
              advertPrivilegeService.updateAdvertPrivileges();                
            }
        };
    }

}

