/**
 * Project Name:engine-service
 * File Name:UpdateAdvertLimitingMsgChannel.java
 * Package Name:cn.com.duiba.tuia.message.channel
 * Date:2017年8月21日下午5:33:28
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.message.channel;

import cn.com.duiba.tuia.cache.AdvertPackageAppAdjustFeeCacheService;
import cn.com.tuia.advert.message.RedisMessageChannel;
import cn.com.tuia.advert.message.consumer.AbstractRedisMessageHandle;
import cn.com.tuia.advert.message.consumer.RedisMessageHandle;
import com.alibaba.fastjson.JSON;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 *签收数据缓存更新
 */
@Component
@RedisMessageHandle(RedisMessageChannel.UPDATE_SIGN_CACHE_MSG)
public class UpdateSignCacheMsgChannel extends AbstractRedisMessageHandle{
    
    @Autowired
    private AdvertPackageAppAdjustFeeCacheService adjustFeeCacheService;

    @Override
    public Runnable createHandle(RedisMessageChannel channel, String message) {
        return () -> {
            logger.info(channel.getChannel() + ";msg=" + message);
            List<String> keys = JSON.parseArray(message, String.class);
            if (CollectionUtils.isNotEmpty(keys)) {
                keys.forEach(key -> adjustFeeCacheService.invalidateAdjustFee(key));
            }
        };
    }
}

