package cn.com.duiba.tuia.message.ons;

import cn.com.duiba.tuia.domain.model.AsynReq;
import cn.com.tuia.advert.model.DirectAdvertLogReq;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.Serializable;
import java.util.UUID;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2017年08月08日 13:44
 * @descript: 直投扣费消息
 * @version: 1.0
 */
@Component
public class DirectPracFeeOnsProducer extends OnsProducer {

    @Autowired
    private  OneMessageTopic oneMessageTopic;

    public void sendMsg(DirectAdvertLogReq spmlogReq, AsynReq asynReq){
        DirectPracFeeOnsProducer.ConsumeFee fee = new DirectPracFeeOnsProducer.ConsumeFee();
        fee.setDirectAdvertLogReq(spmlogReq);
        fee.setAsynReq(asynReq);
        String uniqueKey = UUID.randomUUID().toString();
        sendMsg(JSONObject.toJSONString(fee), uniqueKey);
    }

    @Override
    public String getTopic() {
        return oneMessageTopic.getTuiaTopicRealFee();
    }

    @Override
    public String getTag() {
        return OneMessageTopic.TAG.TAG_DIRECT_PRACTICAL_FEE;
    }

    /**
     * 扣费
     * ClassName: ConsumeFee <br/>
     * Function: TODO ADD FUNCTION. <br/>
     * Reason: TODO ADD REASON(可选). <br/>
     * date: 2017年3月29日 下午7:41:11 <br/>
     *
     * @author zp
     * @version PracFeeOnsProducer
     * @since JDK 1.6
     */
    static class ConsumeFee implements Serializable {
        private static final long serialVersionUID = 1L;
        private DirectAdvertLogReq directAdvertLogReq;
        private  AsynReq  asynReq;

        public AsynReq getAsynReq() {
            return asynReq;
        }

        public void setAsynReq(AsynReq asynReq) {
            this.asynReq = asynReq;
        }

        public DirectAdvertLogReq getDirectAdvertLogReq() {
            return directAdvertLogReq;
        }

        public void setDirectAdvertLogReq(DirectAdvertLogReq directAdvertLogReq) {
            this.directAdvertLogReq = directAdvertLogReq;
        }
    }
}
