/**
 * Project Name:engine-service
 * File Name:OnsProducer.java
 * Package Name:cn.com.duiba.tuia.ons
 * Date:2017年3月28日下午8:09:34
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.message.ons;

import cn.com.tuia.advert.cache.CacheKeyTool;
import cn.com.tuia.advert.cache.RedisCommonKeys;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.Producer;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;

import java.nio.charset.Charset;

import javax.annotation.Resource;

/**
 * ClassName:OnsProducer <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2017年3月28日 下午8:09:34 <br/>
 * @author   zp
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public abstract class OnsProducer {

    private static Logger logger = LoggerFactory.getLogger(OnsProducer.class);
    
    @Autowired
    protected  Producer  onsProducer;
    
    @Resource
    private RedisTemplate<String, String> redisTemplate;
    
    
    protected void sendMsg(String body,String uniqueKey){
        Message msg = new Message(getTopic(),getTag(),
                                  body.getBytes(Charset.forName("utf-8")));
        msg.setKey(uniqueKey);
        try{
            onsProducer.send(msg);
        }catch(Exception e){
            logger.error("消息发送失败",e);
            //兼容处理往redis队列插入消息
            try{
                redisTemplate.opsForList().rightPush(CacheKeyTool.getCacheKey(RedisCommonKeys.KC121), body);
            }catch(Exception ex){
                logger.error("ons计费消息发送失败后降级发送redis失败,",ex);
            }
        }
    }
    
    public abstract String getTopic();
    
    public abstract String getTag();
    
}

