/**
 * Project Name:engine-service
 * File Name:PracticalDedOnsProducer.java
 * Package Name:cn.com.duiba.tuia.ons
 * Date:2017年3月29日下午7:08:55
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.message.ons;

import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import cn.com.duiba.tuia.domain.model.AsynReq;
import cn.com.tuia.advert.model.SpmlogReq;
import com.alibaba.fastjson.JSONObject;

/**
 * ClassName:PracticalDedOnsProducer <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2017年3月29日 下午7:08:55 <br/>
 * @author   zp
 * @version  
 * @since    JDK 1.6
 * @description 实事扣费消息发射器
 * @see 	 
 */
@Component
public class PracFeeOnsProducer extends OnsProducer{
    
    @Autowired
    private  OneMessageTopic oneMessageTopic;
    
    
    public void sendMsg(SpmlogReq spmlogReq,AsynReq asynReq){
        ConsumeFee fee = new ConsumeFee();
        fee.setSpmlogReq(spmlogReq);
        fee.setAsynReq(asynReq);
        sendMsg(JSONObject.toJSONString(fee), asynReq.getAdvertOrderId().toString());
    }

    @Override
    public String getTopic() {
        return oneMessageTopic.getTuiaTopicRealFee();
    }

    @Override
    public String getTag() {
        return OneMessageTopic.TAG.TAG_PRACTICAL_FEE;
    }
    
    /**
     * 扣费
     * ClassName: ConsumeFee <br/>
     * Function: TODO ADD FUNCTION. <br/>
     * Reason: TODO ADD REASON(可选). <br/>
     * date: 2017年3月29日 下午7:41:11 <br/>
     *
     * @author zp
     * @version PracFeeOnsProducer
     * @since JDK 1.6
     */
    static class ConsumeFee implements Serializable{
        private static final long serialVersionUID = 1L;
        private  SpmlogReq  spmlogReq ;
        private  AsynReq  asynReq;
        
        public SpmlogReq getSpmlogReq() {
            return spmlogReq;
        }
        
        public void setSpmlogReq(SpmlogReq spmlogReq) {
            this.spmlogReq = spmlogReq;
        }
        
        public AsynReq getAsynReq() {
            return asynReq;
        }
        
        public void setAsynReq(AsynReq asynReq) {
            this.asynReq = asynReq;
        }
    
        
    }
}

