package cn.com.duiba.tuia.message.rocketmq;

import java.util.UUID;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author peanut.huang
 * @date 2019/8/8
 * @since JDK 1.8
 */
@Component
public class AdvertLaunchMonitorProducer extends RocketMqProducer {

    private static final Logger logger = LoggerFactory.getLogger(AdvertLaunchMonitorProducer.class);

    @Autowired
    private RocketMqMessageTopic rocketMqMessageTopic;
    @Override
    public String getTopic() {
        return rocketMqMessageTopic.getTuiaLaunchMonitor();
    }

    @Override
    public String getTag() {
        return RocketMqMessageTopic.TAG.TAG_LAUNCH_MONITOR;
    }

    public boolean sendMessage(String body) {

        logger.info("AdvertLaunchMonitorProducer send msg={}", body);

        //
        String uniqueKey = UUID.randomUUID().toString();
        try {
            super.sendMsg(body, uniqueKey);
            return true;
        } catch (Exception e) {
            logger.error("AdvertLaunchMonitorProducer send msg error, body={}", body, e);
            return false;
        }
    }

}
