
package cn.com.duiba.tuia.message.rocketmq;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.UUID;

/**
 * 广告扶持计划消息发送生产者
 */
@Component
public class AdvertSupportPlanRocketMqProducer extends RocketMqProducer{

    private static Logger logger = LoggerFactory.getLogger(AdvertSupportPlanRocketMqProducer.class);

    @Autowired
    private RocketMqMessageTopic rocketMessageTopic;
    
    
    public void sendMsg(Long planId){
        try{
            String uniqueKey = UUID.randomUUID().toString();
            super.sendMsg(String.valueOf(planId), uniqueKey);
        }catch(Exception e){
            logger.error("消息发送失败",e);
        }
    }

    @Override
    public String getTopic() {
        return rocketMessageTopic.getTuiaTopicAdvertSupport();
    }

    @Override
    public String getTag() {
        return RocketMqMessageTopic.TAG.TAG_ADVERT_SUPPORT;
    }

}

