package cn.com.duiba.tuia.message.rocketmq;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

import java.util.UUID;

/**
 * @author zhangmeng
 * @date 2019/5/28
 * @function
 */
@Component
@RefreshScope
public class DeviceApiRocketMqProducer extends RocketMqProducer{

    private static final Logger logger = LoggerFactory.getLogger(DeviceApiRocketMqProducer.class);

    @Value("${tuia.engine.mq.switch:true}")
    private Boolean isOpen;

    @Autowired
    private RocketMqMessageTopic rocketMqMessageTopic;

    @Override
    public void sendMsg(String body,String uniqueKey ) throws Exception {
        if(!isOpen){
            return;
        }
        logger.info("DeviceApiRocketMqProducer:{}",body);
        uniqueKey = UUID.randomUUID().toString();
        super.sendMsg(body, uniqueKey);
    }

    @Override
    public String getTopic() {
        return rocketMqMessageTopic.getTuiaTopicDeviceApi();
    }

    @Override
    public String getTag() {
        return RocketMqMessageTopic.TAG.TAG_EXPOSE_ADVERT_ENGINE;
    }
}
