package cn.com.duiba.tuia.message.rocketmq;


import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

import java.util.UUID;


/**
 * 广告主数据归因 ip漂移检查
 */

@Component
@RefreshScope
public class DeviceIpDriftCheckProducer extends RocketMqProducer{

    private static final Logger logger = LoggerFactory.getLogger(DeviceIpDriftCheckProducer.class);

    @Value("${tuia.engine.mq.ipcheck.switch:true}")
    private Boolean isOpen;

    @Autowired
    private RocketMqMessageTopic rocketMqMessageTopic;

    @Override
    public String getTopic() {
        return rocketMqMessageTopic.getTuiaTopicIpDrift();
    }

    @Override
    public String getTag() {
        return RocketMqMessageTopic.TAG.TAG_IP_DRIFT;
    }

    @Override
    public void sendMsg(String body, String uniqueKey) throws Exception {

        if(!isOpen){
            return;
        }
        logger.info("DeviceApiRocketMqProducer:{}",body);
        uniqueKey = UUID.randomUUID().toString();
        super.sendMsg(body, uniqueKey);
    }


}
