/**
 * Project Name:engine-service
 * File Name:DirectPracFeeRocketMqProducer.java
 * Package Name:cn.com.duiba.tuia.message.rocketmq
 * Date:2018年6月27日下午5:12:49
 * Copyright (c) 2018, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.message.rocketmq;

import java.io.Serializable;
import java.util.UUID;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.com.duiba.tuia.domain.model.AsynReq;
import cn.com.duiba.tuia.message.ons.DirectPracFeeOnsProducer;
import cn.com.tuia.advert.model.DirectAdvertLogReq;

import com.alibaba.fastjson.JSONObject;

/**
 * ClassName:DirectPracFeeRocketMqProducer <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2018年6月27日 下午5:12:49 <br/>
 * @author   zp
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Component
public class DirectPracFeeRocketMqProducer extends RocketMqProducer{

    private static Logger logger = LoggerFactory.getLogger(DirectPracFeeRocketMqProducer.class);
    @Autowired
    private RocketMqMessageTopic rocketMqMessageTopic;
    @Autowired
    private DirectPracFeeOnsProducer directPracFeeOnsProducer;
    
    @Override
    public String getTopic() {
        return rocketMqMessageTopic.getTuiaTopicRealFee();
    }

    @Override
    public String getTag() {
        return RocketMqMessageTopic.TAG.TAG_DIRECT_PRACTICAL_FEE;
    }
    
    public void sendMsg(DirectAdvertLogReq spmlogReq, AsynReq asynReq){
        ConsumeFee fee = new ConsumeFee();
        fee.setDirectAdvertLogReq(spmlogReq);
        fee.setAsynReq(asynReq);
        String uniqueKey = UUID.randomUUID().toString();
        try{
            sendMsg(JSONObject.toJSONString(fee), uniqueKey);
        }catch(Exception e){
            logger.error("消息发送失败",e);
            directPracFeeOnsProducer.sendMsg(spmlogReq, asynReq);
        }
    }
    
    /**
     * 扣费
     * ClassName: ConsumeFee <br/>
     * Function: TODO ADD FUNCTION. <br/>
     * Reason: TODO ADD REASON(可选). <br/>
     * date: 2017年3月29日 下午7:41:11 <br/>
     *
     * @author zp
     * @version PracFeeOnsProducer
     * @since JDK 1.6
     */
    static class ConsumeFee implements Serializable {
        private static final long serialVersionUID = 1L;
        private DirectAdvertLogReq directAdvertLogReq;
        private  AsynReq  asynReq;

        public AsynReq getAsynReq() {
            return asynReq;
        }

        public void setAsynReq(AsynReq asynReq) {
            this.asynReq = asynReq;
        }

        public DirectAdvertLogReq getDirectAdvertLogReq() {
            return directAdvertLogReq;
        }

        public void setDirectAdvertLogReq(DirectAdvertLogReq directAdvertLogReq) {
            this.directAdvertLogReq = directAdvertLogReq;
        }
    }

}

