package cn.com.duiba.tuia.message.rocketmq;

import com.alibaba.fastjson.JSONObject;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.Serializable;

/**
 * Created by huazheng on 2017/9/5.
 */
@Component
public class ExposureRocketMqProducer extends RocketMqProducer {
    
    private static Logger logger = LoggerFactory.getLogger(ExposureRocketMqProducer.class);

    @Autowired
    private RocketMqMessageTopic rocketMqMessageTopic;

    public void sendMsg(Long advertId, Long materialId, Long appId) {
        // 这里使用string类型.是消费端的要求....配合他们
        ExposureDO exposure = new ExposureDO(advertId, materialId, appId);
        try{
            sendMsg(JSONObject.toJSONString(exposure), advertId.toString() + "_exposure");
        }catch(Exception e){
            logger.error("消息发送失败",e);
        }
    }

    @Override
    public String getTopic() {
        return rocketMqMessageTopic.getTuiaTopicRoi();
    }

    @Override
    public String getTag() {
        return RocketMqMessageTopic.TAG.TAG_MATERIAL_EXPOSURE;
    }

    static class ExposureDO implements Serializable {

        private static final long serialVersionUID = 1L;
        private Long              advertId;
        private Long              materialId;
        private Long              appId;

        ExposureDO(Long advertId, Long materialId, Long appId) {
            this.advertId = advertId;
            this.materialId = materialId;
            this.appId = appId;
        }

        public Long getAdvertId() {
            return advertId;
        }

        public void setAdvertId(Long advertId) {
            this.advertId = advertId;
        }

        public Long getMaterialId() {
            return materialId;
        }

        public void setMaterialId(Long materialId) {
            this.materialId = materialId;
        }

        public Long getAppId() {
            return appId;
        }

        public void setAppId(Long appId) {
            this.appId = appId;
        }
    }
}
