/**
 * Project Name:engine-service
 * File Name:PracFeeRocketMqProducer.java
 * Package Name:cn.com.duiba.tuia.message.rocketmq
 * Date:2018年6月27日下午5:06:28
 * Copyright (c) 2018, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.message.rocketmq;

import java.io.Serializable;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSONObject;

import cn.com.duiba.tuia.domain.model.AsynReq;
import cn.com.duiba.tuia.message.ons.PracFeeOnsProducer;
import cn.com.tuia.advert.model.SpmlogReq;

/**
 * ClassName:PracFeeRocketMqProducer <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2018年6月27日 下午5:06:28 <br/>
 * @author   zp
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Component
public class PracFeeRocketMqProducer extends RocketMqProducer{
    
    private static Logger logger = LoggerFactory.getLogger(PracFeeRocketMqProducer.class);

    @Autowired
    private RocketMqMessageTopic rocketMqMessageTopic;
    @Autowired
    private PracFeeOnsProducer pracFeeOnsProducer;

    @Override
    public String getTopic() {
        return rocketMqMessageTopic.getTuiaTopicRealFee();
    }

    @Override
    public String getTag() {
        return RocketMqMessageTopic.TAG.TAG_PRACTICAL_FEE;
    }
    
    public void sendMsg(SpmlogReq spmlogReq,AsynReq asynReq){
        ConsumeFee fee = new ConsumeFee();
        fee.setSpmlogReq(spmlogReq);
        fee.setAsynReq(asynReq);
        try{
            sendMsg(JSONObject.toJSONString(fee), asynReq.getAdvertOrderId().toString());
        }catch(Exception e){
            logger.error("消息发送失败",e);
            pracFeeOnsProducer.sendMsg(spmlogReq, asynReq);
        }
    }
    
    /**
     * 扣费
     * ClassName: ConsumeFee <br/>
     * Function: TODO ADD FUNCTION. <br/>
     * Reason: TODO ADD REASON(可选). <br/>
     * date: 2017年3月29日 下午7:41:11 <br/>
     *
     * @author zp
     * @version PracFeeOnsProducer
     * @since JDK 1.6
     */
     static class ConsumeFee implements Serializable{
        private static final long serialVersionUID = 1L;
        private  SpmlogReq  spmlogReq ;
        private  AsynReq  asynReq;
        
        public SpmlogReq getSpmlogReq() {
            return spmlogReq;
        }
        
        public void setSpmlogReq(SpmlogReq spmlogReq) {
            this.spmlogReq = spmlogReq;
        }
        
        public AsynReq getAsynReq() {
            return asynReq;
        }
        
        public void setAsynReq(AsynReq asynReq) {
            this.asynReq = asynReq;
        }
    }

}

