/**
 * Project Name:engine-service File Name:PracticalDedOnsProducer.java Package Name:cn.com.duiba.tuia.ons
 * Date:2017年3月29日下午7:08:55 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.message.rocketmq;

import java.nio.charset.Charset;
import java.util.UUID;

import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.message.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 广告业务消息发送生产者
 */
@Component
public class RefreshCacheMqProducer extends RocketMqSimpleProducer {

    @Autowired
    private RocketMqMessageTopic rocketMqMessageTopic;

    public void sendMsg(String tag, String body) {
        sendMsg(tag, body, UUID.randomUUID().toString());
    }

    @Override
    public String getTopic() {
        return rocketMqMessageTopic.getTuiaTopicRefreshTopic();
    }


}
