package cn.com.duiba.tuia.message.rocketmq;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 *
 */
@Component
public class RocketMqMessageTopic {
    
    @Value("${tuia.engine.topic.tuiaroi}")
    private String tuiaTopicRoi;
  
    @Value("${tuia.engine.topic.tuiaRealFee}")
    private String tuiaTopicRealFee;

    @Value("${tuia.engine.topic.tuiaRealFeeHot:tuiaRealFeeWhiteProd}")
    private String tuiaTopicRealFeeHot;

    @Value("${tuia.engine.topic.deviceApi}")
    private String tuiaTopicDeviceApi;

     @Value("${tuia.engine.topic.monitor}")
    private String tuiaLaunchMonitor;

    @Value("${tuia.engine.topic.refreshcache}")
    private String tuiaTopicRefreshTopic;

    @Value("${tuia.engine.topic.ipDrift}")
    private String tuiaTopicIpDrift;

    @Value("${tuia.engine.topic.advertSupport}")
    private String tuiaTopicAdvertSupport;

    public String getTuiaTopicRealFeeHot() {
        return tuiaTopicRealFeeHot;
    }

    public String getTuiaTopicRealFee() {
        return tuiaTopicRealFee;
    }

    public String getTuiaLaunchMonitor() {
        return tuiaLaunchMonitor;
    }

    public void setTuiaTopicRealFee(String tuiaTopicRealFee) {
        this.tuiaTopicRealFee = tuiaTopicRealFee;
    }

    //获取点击主题 value="RoiClick"
    public String getTuiaTopicRoi() {
        return tuiaTopicRoi;
    }

    public void setTuiaTopicRoi(String tuiaTopicRoi) {
        this.tuiaTopicRoi = tuiaTopicRoi;
    }

    public String getTuiaTopicDeviceApi() {
        return tuiaTopicDeviceApi;
    }

    public void setTuiaTopicDeviceApi(String tuiaTopicDeviceApi) {
        this.tuiaTopicDeviceApi = tuiaTopicDeviceApi;
    }

    public String getTuiaTopicRefreshTopic() {
        return tuiaTopicRefreshTopic;
    }

    public RocketMqMessageTopic setTuiaTopicRefreshTopic(String tuiaTopicRefreshTopic) {
        this.tuiaTopicRefreshTopic = tuiaTopicRefreshTopic;
        return this;
    }

    public String getTuiaTopicIpDrift() {
        return tuiaTopicIpDrift;
    }

    public void setTuiaTopicIpDrift(String tuiaTopicIpDrift) {
        this.tuiaTopicIpDrift = tuiaTopicIpDrift;
    }

    public String getTuiaTopicAdvertSupport() {
        return tuiaTopicAdvertSupport;
    }

    public void setTuiaTopicAdvertSupport(String tuiaTopicAdvertSupport) {
        this.tuiaTopicAdvertSupport = tuiaTopicAdvertSupport;
    }

    class TAG{
        /**
         * 广告点击标签tag
         */
        public static final String TAG_ROI_CLICK = "click";
        
        /**
         * 素材点击
         */
        public static final String TAG_MATERIAL_CLICK = "material_click";

        /**
         * 素材曝光
         */
        public static final String TAG_MATERIAL_EXPOSURE = "material_exposure";
        
        /**
         * 推啊实事扣费tag
         */
        public static final String TAG_PRACTICAL_FEE = "tuiaPracticalFee";

        /**
         * 推啊实时扣费热点
         */
        public static final String TAG_PRACTICAL_FEE_HOT = "tuiaPracticalFeeWhite";

        /**
         * 直投扣费tag
         */
        public static final String TAG_DIRECT_PRACTICAL_FEE = "tuiaDirectPracticalFee";

        /**
         * 落地页曝光 发送消息到活动
         */
        public static final String TAG_EXPOSE_ADVERT_ENGINE = "tagExposeAdvertEngine";


        /**
         * 广告发券监控tag
         */
        public static final String TAG_LAUNCH_MONITOR = "advertLaunchMonitorTag";

        /**
         * 广告主数据归因 ip漂移
         */
        public static final String TAG_IP_DRIFT = "tagIpDrift";

        /**
         * 广告主数据归因 ip漂移
         */
        public static final String TAG_ADVERT_SUPPORT = "advertSupportPlanTag";
    }
}

