package cn.com.duiba.tuia.message.rocketmq;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.common.message.Message;
import org.springframework.beans.factory.annotation.Autowired;

import java.nio.charset.Charset;

/**
 * Created by huazheng on 2017/9/5.
 */
public abstract class RocketMqProducer {

    @Autowired
    private DefaultMQProducer rocketMqProducer;

    public void sendMsg(String body,String uniqueKey) throws Exception{
        Message msg = new Message(getTopic(),getTag(), body.getBytes(Charset.forName("utf-8")));
        msg.setKeys(uniqueKey);
        rocketMqProducer.send(msg);
    }

    public abstract String getTopic();

    public abstract String getTag();
    
}
