package cn.com.duiba.tuia.message.rocketmq;

import java.nio.charset.Charset;
import java.util.UUID;

import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class RocketMqSimpleProducer {

    private static Logger       logger = LoggerFactory.getLogger(RocketMqSimpleProducer.class);

    @Autowired
    protected DefaultMQProducer defaultMQProducer;

    public void sendMsg(String tag, String body, String uniqueKey) {
        Message msg = new Message(getTopic(), tag, body.getBytes(Charset.forName("utf-8")));
        msg.setKeys(uniqueKey);
        try {
            defaultMQProducer.send(msg);
        } catch (Exception e) {
            logger.error("消息发送失败", e);
        }
    }

    public abstract String getTopic();

    public String sendMsgWithId(String tag, String body){
        logger.info("send mag:topic=" + this.getTopic() + ",tag=" + tag + ",msg=" + body);
        Message msg = new Message(getTopic(), tag, body.getBytes(Charset.forName("utf-8")));
        msg.setKeys(UUID.randomUUID().toString());
        try{
            SendResult result = defaultMQProducer.send(msg);
            logger.info("send msg:topic=" + this.getTopic() + ",tag=" + tag + ", msgId=" + result.getMsgId());
            return result.getMsgId();
        }catch(Exception e){
            logger.error("消息发送失败",e);
        }
        return "";
    }
}
