
package cn.com.duiba.tuia.message.rocketmq;

import cn.com.duiba.tuia.domain.model.AdvertClick;

import com.alibaba.fastjson.JSONObject;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 广告点击消息发送生产者
 */
@Component
public class RoiClickRocketMqProducer extends RocketMqProducer{

    private static Logger logger = LoggerFactory.getLogger(RoiClickRocketMqProducer.class);

    @Autowired
    private  RocketMqMessageTopic rocketMessageTopic;
    
    
    public void sendMsg(AdvertClick click,String advertId){

        //这里使用string类型.是消费端的要求....配合他们
        try{
            sendMsg(JSONObject.toJSONString(click), advertId);
        }catch(Exception e){
            logger.error("消息发送失败",e);
        }
    }

    @Override
    public String getTopic() {
        return rocketMessageTopic.getTuiaTopicRoi();
    }

    @Override
    public String getTag() {
        return RocketMqMessageTopic.TAG.TAG_ROI_CLICK;
    }

}

