package cn.com.duiba.tuia.message.rocketmq.listener;

import cn.com.duiba.tuia.cache.ServiceManager;
import cn.com.tuia.advert.cache.RedisCommonKeys;
import com.alibaba.fastjson.JSON;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 刷新广告缓存消息
 */
@Component
public class RefreshAdvertExpandCacheHandler extends AbstractMessageResultHandler {

    @Autowired
    private ServiceManager serviceManager;

    @Override
    public String getListenTag() {
        return RedisCommonKeys.KC141.toString();
    }

    @Override
    public void consumer(String message) {
        logger.info("Topic:{},Msg:{}",getListenTag(),message);
        if (StringUtils.isBlank(message)) {
            return;
        }
        List<Long> advertIds = JSON.parseArray(message, Long.class);
        serviceManager.refreshAdvertExpandCache(advertIds);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        //在消息处理器中注册
        RocketMqMessageListener.registerCallback(this);
    }
}
