package cn.com.duiba.tuia.message.rocketmq.listener;

import cn.com.duiba.tuia.domain.vo.MessageVO;
import cn.com.duiba.tuia.service.LimitingMaximunService;
import cn.com.tuia.advert.constants.ConfigRocketMqTags;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author huangruodan
 * @version 创建时间：2020/10/22 11:27 上午
 */
@Component
public class RefreshAdvertLimitingMsgHandler extends AbstractMessageResultHandler {

    @Autowired
    private LimitingMaximunService maximunCacheService;

    @Override
    public String getListenTag() {
        return ConfigRocketMqTags.UPDATE_ADVERT_LIMITING_MSG;
    }

    @Override
    public void consumer(String message) {
        logger.info("接收到消息，tag=" + getListenTag() + ",msg="+message);
        MessageVO messageVO = MessageVO.createByJson(message, getListenTag());
        Long advertId = messageVO.getAdvertId();
        Long orientationPackageId = messageVO.getOrientationPackageId();
        Long appId = messageVO.getAppId();

        if (advertId == null || orientationPackageId == null) {
            return;
        }
        //更新当天限流媒体是否达到峰值
        maximunCacheService.updateLimitingMaximunCache(advertId, orientationPackageId, appId);
        logger.info("success，tag=" + getListenTag() + ",msg="+message);

    }

    @Override
    public void afterPropertiesSet() throws Exception {
        //在消息处理器中注册
        RocketMqMessageListener.registerCallback(this);
    }
}
