package cn.com.duiba.tuia.message.rocketmq.listener;

import cn.com.duiba.tuia.cache.ActPreCache;
import cn.com.tuia.advert.constants.ConfigRocketMqTags;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author huangruodan
 * @version 创建时间：2020/10/21 11:44 上午
 */
@Component
public class RefreshAdvertMaterialActMsgHandler extends AbstractMessageResultHandler {

    @Autowired
    private ActPreCache actPreCache;

    @Override
    public String getListenTag() {
        return ConfigRocketMqTags.UPDATE_ADVERT_MATERIAL_ACT_MSG;
    }

    @Override
    public void consumer(String message) {
        logger.info("接收到消息，tag=" + getListenTag() + ",msg= " + message);
        JSONObject jsonObject = JSONObject.parseObject(message);

        // 情况广告活动预发券素材缓存
        Long advertId = jsonObject.getLong("advertId");
        String newTrade = jsonObject.getString("newTrade");
        actPreCache.refresh(advertId, newTrade);
        logger.info("success，tag=" + getListenTag() + ",msg="+message);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        RocketMqMessageListener.registerCallback(this);
    }
}
