package cn.com.duiba.tuia.message.rocketmq.listener;

import cn.com.duiba.tuia.cache.AdvertPkgPutFlagCacheService;
import cn.com.duiba.tuia.exception.TuiaException;
import cn.com.tuia.advert.constants.ConfigRocketMqTags;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.text.ParseException;

/**
 * @author huangruodan
 * @version 创建时间：2020/10/22 1:46 下午
 */
@Component
public class RefreshAdvertPkgPutMsgHandler extends AbstractMessageResultHandler {

    @Autowired
    private AdvertPkgPutFlagCacheService advertPkgPutFlagCacheService;

    @Override
    public String getListenTag() {
        return ConfigRocketMqTags.UPDATE_ADVERT_PKG_PUT_MSG;
    }

    @Override
    public void consumer(String message) {
        try {
            logger.info("接收到消息，tag=" + getListenTag() + ",msg="+message);

            advertPkgPutFlagCacheService.updateAdvertPkgPutFlag(message);
        } catch (TuiaException e) {
            logger.error("redis msg updateAdvertPkgPutFlag error",e);
        } catch (ParseException e) {
            logger.error("redis msg updateAdvertPkgPutFlag error ParseException",e);
        }
        logger.info("success，tag=" + getListenTag() + ",msg="+message);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        //在消息处理器中注册
        RocketMqMessageListener.registerCallback(this);
    }
}
