package cn.com.duiba.tuia.message.rocketmq.listener;

import cn.com.duiba.tuia.cache.MakeTagCacheService;
import cn.com.duiba.tuia.tool.StringTool;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;


@Component
public class RefreshAdvertPromoteTestCacheHandler extends AbstractMessageResultHandler {


    @Autowired
    private MakeTagCacheService makeTagCacheService;

    @Override
    public String getListenTag() {
        return "advertPromoteTestMqTag";
    }

    @Override
    public void consumer(String message) {
        List<String> stringListByStrAndRegex = StringTool.getStringListByStrAndRegex(message, "--");
        logger.info("Topic:{},Msg:{}", getListenTag(), message);
        if (stringListByStrAndRegex.size() == 4) {
            //四个的情况是兼容.以前是传advertId+"--"+urlType+"--"+url   现在+"promoteId"

            //advertId+"--"+urlType+"--"+url
            String refreshAdvertPromoteKey = stringListByStrAndRegex.get(0) +"--"+ stringListByStrAndRegex.get(1)+"--" + stringListByStrAndRegex.get(2);
            makeTagCacheService.refreshAdvertPromoteTest(refreshAdvertPromoteKey);
            String promoteId =stringListByStrAndRegex.get(3);
            makeTagCacheService.refreshPromotePromoteTagsCacheCache(promoteId);
        }

        if (stringListByStrAndRegex.size() == 3) {
            //advertId+"--"+urlType+"--"+url
            makeTagCacheService.refreshAdvertPromoteTest(message);
        }


    }

    @Override
    public void afterPropertiesSet() throws Exception {
        //在消息处理器中注册
        RocketMqMessageListener.registerCallback(this);
    }
}
