package cn.com.duiba.tuia.message.rocketmq.listener;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.com.duiba.tuia.cache.AdvertRepeatLunchConfigCacheService;
import cn.com.tuia.advert.constants.RocketMqCommonkeys;

/**
 * 
 * ClassName: RefreshAdvertRepeatLunchConfigHandler <br/>
 * Function:  广告重复发券间隔特殊资源配置消息. <br/>
 * date: 2019年1月8日 下午5:48:14 <br/>
 *
 * @author chencheng
 * @version 
 * @since JDK 1.8
 */
@Component
public class RefreshAdvertRepeatLunchConfigHandler extends AbstractMessageResultHandler{

    @Autowired
    private AdvertRepeatLunchConfigCacheService advertRepeatLunchConfigCacheService;

    @Override
    public String getListenTag() {
        return RocketMqCommonkeys.ADVERT_REPEAT_LUNCH_CONFIG;
    }

    @Override
    public void consumer(String message) {
        try{
            if (StringUtils.isBlank(message)) {
                return;
            }
            logger.info("Topic:{},Msg:{}",getListenTag(),message);
            advertRepeatLunchConfigCacheService.refresh(Integer.parseInt(message));
            
        }catch (Exception e){
            logger.error("广告重复发券间隔特殊资源配置缓存更新异常！message=[{}]", message);
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        RocketMqMessageListener.registerCallback(this);
    }
}
