package cn.com.duiba.tuia.message.rocketmq.listener;

import cn.com.duiba.tuia.cache.AdvertSupportPlanCacheManager;
import cn.com.tuia.advert.constants.ConfigRocketMqTags;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Objects;

/**
 * @author huangruodan
 * @version 创建时间：2020/10/22 1:49 下午
 */
@Component
public class RefreshAdvertSupportMsgHandler extends AbstractMessageResultHandler {

    @Resource
    private AdvertSupportPlanCacheManager advertSupportPlanCacheManager;

    @Override
    public String getListenTag() {
        return ConfigRocketMqTags.UPDATE_ADVERT_SUPPORT_MSG;
    }

    @Override
    public void consumer(String message) {
        logger.info("接收到消息，tag=" + getListenTag() + ",msg="+message);

        JSONObject jsonObject = JSONObject.parseObject(message);
        Long advertId = jsonObject.getLong("advertId");
        if (Objects.nonNull(advertId)) {
            advertSupportPlanCacheManager.refresh();
        }
        logger.info("success，tag=" + getListenTag() + ",msg="+message);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        //在消息处理器中注册
        RocketMqMessageListener.registerCallback(this);
    }
}
