package cn.com.duiba.tuia.message.rocketmq.listener;

import cn.com.duiba.tuia.bo.AdvertBannedTagBo;
import cn.com.duiba.tuia.domain.vo.AdvertOrientationPackageVO;
import cn.com.duiba.tuia.domain.vo.MessageVO;
import cn.com.duiba.tuia.service.AdvertOrientationService;
import cn.com.duiba.tuia.service.ResourceTagsService;
import cn.com.tuia.advert.constants.ConfigRocketMqTags;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 更新广告标签消息
 */
@Component
public class RefreshAdvertTagMsgHandler extends AbstractMessageResultHandler {

    @Autowired
    private AdvertBannedTagBo advertBannedTagBo;

    @Autowired
    private ResourceTagsService resourceTagsService;

    @Autowired
    private AdvertOrientationService advertOrientationService;

    /**
     * 获取消费tag
     * getListenTag:(这里用一句话描述这个方法的作用). <br/>
     *
     * @return
     * @author zf
     * @since JDK 1.6
     */
    @Override
    public String getListenTag() {
        return ConfigRocketMqTags.UPDATE_ADVERT_TAG_MSG;
    }

    /**
     * 消费消息
     *
     * @param message
     * @author zf
     * @since JDK 1.6
     */
    @Override
    public void consumer(String message) {
        logger.info("接收到消息，tag=" + ConfigRocketMqTags.UPDATE_ADVERT_TAG_MSG + ",msg="+message);

        try {
            MessageVO messageVO = MessageVO.createByJson(message, ConfigRocketMqTags.UPDATE_ADVERT_TAG_MSG);
            Long advertId = messageVO.getAdvertId();
            Long orientationPackageId = messageVO.getOrientationPackageId();

            if (advertId == null) {
                return;
            }

            if (orientationPackageId != null){
                //将配置标签从缓存中移除
                advertBannedTagBo.deleteBannedCacheByAdvertIdAndOrientataionPackageId(advertId,
                        orientationPackageId);
            }else {
                //如果配置包ID为null，将广告下配置包的屏蔽标签为沿用的配置包标签缓存删除
                List<AdvertOrientationPackageVO> listAdvertOrientationPackage = advertOrientationService.getOrientationList(advertId);
                List<Long> listAdvertOrientationPackageIds = listAdvertOrientationPackage.stream()
                        .map(orientationPackage -> {
                            return orientationPackage.isDefaultOrientation() ? 0L: orientationPackage.getId();
                        }).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(listAdvertOrientationPackageIds)) {
                    return;
                }
                listAdvertOrientationPackageIds.forEach(packageId -> advertBannedTagBo.deleteBannedCacheByAdvertIdAndOrientataionPackageId(advertId, packageId));

                resourceTagsService.refreshResourceCache(advertId);
            }
        } catch (Exception e) {
            logger.error("RefreshAdvertTagMsgHandler msg error msg[{}],exception:{}", message, e);
        }
    }

    /**
     * Invoked by the containing {@code BeanFactory} after it has set all bean properties
     * and satisfied {@link BeanFactoryAware}, {@code ApplicationContextAware} etc.
     * <p>This method allows the bean instance to perform validation of its overall
     * configuration and final initialization when all bean properties have been set.
     *
     * @throws Exception in the event of misconfiguration (such as failure to set an
     *                   essential property) or if initialization fails for any other reason
     */
    @Override
    public void afterPropertiesSet() throws Exception {
        RocketMqMessageListener.registerCallback(this);
    }
}
