package cn.com.duiba.tuia.message.rocketmq.listener;

/**
 * @author zhangmeng
 * @date 2018/12/10
 * @function 接收center发来的行业人群包变更消息
 */
import cn.com.duiba.tuia.service.AdvertTradePackageService;
import cn.com.tuia.advert.constants.RocketMqCommonkeys;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RefreshAdvertTradePackageHandler extends AbstractMessageResultHandler{


    @Autowired
    private AdvertTradePackageService advertTradePackageService;

    @Override
    public String getListenTag() {
        return RocketMqCommonkeys.CHANGE_TRADE_PACKAGE_TAG;
    }

    @Override
    public void consumer(String message) {
        logger.info("RefreshAdvertTradePackageHandler consumer:{}",message);
        advertTradePackageService.refreshCache();
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        RocketMqMessageListener.registerCallback(this);
    }
}
