package cn.com.duiba.tuia.message.rocketmq.listener;

import cn.com.duiba.tuia.cache.AdvertABTestCacheService;
import cn.com.duiba.tuia.cache.AdvertPkgCacheService;
import cn.com.duiba.tuia.domain.vo.AdvertOrientationPackageVO;
import cn.com.duiba.tuia.service.AdvertOrientationService;
import cn.com.tuia.advert.model.messageDto.AdvertMsg;
import com.alibaba.fastjson.JSON;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import java.util.List;

/**
 * 刷新广告url缓存消息
 */
@Component
public class RefreshAdvertUrlCacheHandler extends AbstractMessageResultHandler {

    @Autowired
    private AdvertABTestCacheService advertABTestCacheService;
    @Autowired
    private AdvertPkgCacheService advertPkgCacheService;

    /** 更新广告链接消息 */
    private static final String UPDATE_ADVERT_URL_MSG      = "updateAdvertUrlIdsMsg";

    /**
     * 获取消费tag
     * getListenTag:(这里用一句话描述这个方法的作用). <br/>
     *
     * @return
     * @author zf
     * @since JDK 1.6
     */
    @Override
    public String getListenTag() {
        return UPDATE_ADVERT_URL_MSG;
    }

    /**
     * 消费消息
     *
     * @param message
     * @author zf
     * @since JDK 1.6
     */
    @Override
    public void consumer(String message) {

        logger.info("接收到消息，tag=" + getListenTag() + ", msg=" + message);

        AdvertMsg advertMsg = JSON.parseObject(message, AdvertMsg.class);
        List<Long> ids = advertMsg.getIds();

        if (CollectionUtils.isEmpty(ids)){
            return;
        }

        for (Long advertId : ids) {
            //更新ABTest缓存
            advertABTestCacheService.updateAdvertABTestCache(advertId);
            //更新广告配置缓存
            advertPkgCacheService.updateAdvertOrientPkgCache(advertId);
        }
        logger.info("success，tag=" + getListenTag() + ", msg="+message);
    }

    /**
     * Invoked by the containing {@code BeanFactory} after it has set all bean properties
     * and satisfied {@link BeanFactoryAware}, {@code ApplicationContextAware} etc.
     * <p>This method allows the bean instance to perform validation of its overall
     * configuration and final initialization when all bean properties have been set.
     *
     * @throws Exception in the event of misconfiguration (such as failure to set an
     *                   essential property) or if initialization fails for any other reason
     */
    @Override
    public void afterPropertiesSet() throws Exception {
        RocketMqMessageListener.registerCallback(this);
    }
}
