package cn.com.duiba.tuia.message.rocketmq.listener;

import cn.com.duiba.tuia.cache.AdvertMapCacheManager;
import cn.com.duiba.tuia.cache.AdvertPromoteTestCacheService;
import cn.com.duiba.tuia.constants.AdvertConstants;
import cn.com.duiba.tuia.dao.dmp.DmpAdvertDAO;
import cn.com.duiba.tuia.dao.engine.AdvertOrientationPackageDAO;
import cn.com.duiba.tuia.dao.promotetest.AdvertPromoteTestDAO;
import cn.com.duiba.tuia.domain.dataobject.AdvertOrientationPackageDO;
import cn.com.duiba.tuia.domain.dataobject.AdvertPromoteTestDO;
import cn.com.duiba.tuia.domain.dataobject.DmpAdvertDO;
import cn.com.duiba.tuia.service.AdvertOrientationService;
import cn.com.tuia.advert.constants.SystemConfigKeyConstant;
import cn.com.tuia.advert.enums.PkgPutTypeEnum;
import com.alibaba.fastjson.JSONArray;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

@Component
public class RefreshAdvertiserAuditPromoteurlHandler extends AbstractMessageResultHandler{


    @Autowired
    private AdvertPromoteTestCacheService advertPromoteTestCacheService;

    @Autowired
    private AdvertPromoteTestDAO advertPromoteTestDAO;

    @Autowired
    private AdvertMapCacheManager advertMapCacheManager;

    @Autowired
    private AdvertOrientationPackageDAO orientationPackageDAO;

    @Autowired
    private AdvertOrientationService orientationService;

    @Override
    public String getListenTag() {
        return SystemConfigKeyConstant.ADVERTISER_ADUIT_PROMOTE_MSG;
    }

    @Override
    public void consumer(String message) {

        List<String> msgList = null;
        try {
            msgList = JSONArray.parseArray(message, String.class);
        } catch (Exception e) {
            logger.error("参数解析异常，传参="+message,e);
        }

        if (CollectionUtils.isEmpty(msgList)) {
            return;
        }


        List<Long> promoteIds = new ArrayList<>(msgList.size());
        for (String msg : msgList) {
            try {
                String[] split = msg.split("-");
                Long advertId = Long.valueOf(split[0]);
                Long promoteUrlId = Long.valueOf(split[1]);

                promoteIds.add(promoteUrlId);

                //刷新 落地页测试缓存
                advertPromoteTestCacheService.refreshPromoteCache(advertId);
            } catch (NumberFormatException e) {
                logger.error("异常",e);
            }

        }

        List<Long> materialIds =  advertPromoteTestDAO.selectBindMaterialIdsByPromoteUrlIds(promoteIds);
        if (CollectionUtils.isNotEmpty(materialIds)) {
            for (Long materialId : materialIds) {
                //刷新 素材绑定落地页测试缓存
                advertPromoteTestCacheService.refreshMaterialCache(materialId);
            }
        }

        List<AdvertPromoteTestDO> advertPromoteTestDOS = advertPromoteTestDAO.selectByPrimaryKeys(promoteIds);
        if(CollectionUtils.isNotEmpty(advertPromoteTestDOS)){
            for (AdvertPromoteTestDO advertPromoteTestDO : advertPromoteTestDOS) {
                //刷新配置缓存
                Long orientPackageId = advertPromoteTestDO.getOrientPackageId();
                Long advertId = advertPromoteTestDO.getAdvertId();

                AdvertOrientationPackageDO orientationPackageDO = orientationPackageDAO.selectById(orientPackageId);
                // 配置投放类型
                if (orientationPackageDO == null || !orientationPackageDO.getPkgPutType().equals(PkgPutTypeEnum.INTERACTIVE_TYPE.getCode())) {
                    return;
                }
                orientationService.updateOrientation(orientationPackageDO);
                if (orientationPackageDO.getIsDefault().equals(AdvertConstants.DEFAULT_ORIENTATION)) {
                    orientPackageId = 0L;
                }

                advertMapCacheManager.updateValidPkgFilterCache(advertId,orientPackageId);
            }
        }
    }


    @Override
    public void afterPropertiesSet() throws Exception {
        RocketMqMessageListener.registerCallback(this);
    }

}
