package cn.com.duiba.tuia.message.rocketmq.listener;

import cn.com.duiba.tuia.service.DspComparePriceService;
import cn.com.tuia.advert.cache.RedisCommonKeys;
import cn.com.tuia.advert.constants.CommonConstant;
import cn.com.tuia.advert.model.messageDto.AdxAdvertMsg;
import com.alibaba.fastjson.JSON;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 刷新dsp adx广告缓存消息
 */
@Component
public class RefreshAdxAdvertCacheHandler extends AbstractMessageResultHandler {


    @Autowired
    private DspComparePriceService dspComparePriceService;

    @Override
    public String getListenTag() {
        return RedisCommonKeys.KC148.toString();
    }

    @Override
    public void consumer(String message) {
        logger.info("Topic:{},Msg:{}", getListenTag(), message);
        if (StringUtils.isBlank(message)) {
            return;
        }
        AdxAdvertMsg adxAdvertMsg = JSON.parseObject(message, AdxAdvertMsg.class);
        int type = adxAdvertMsg.getType();
        List<Long> ids = adxAdvertMsg.getIds();

        //只更新互动广告
        Integer advertType = adxAdvertMsg.getAdvertType();
        if (advertType != null && advertType != CommonConstant.HD_ADVERT_TYPE) {
            return;
        }
        //更新特定广告缓存
        if (type == AdxAdvertMsg.UPDATE_TRAGET) {
            for (Long advertId : ids) {
                String key = String.valueOf(adxAdvertMsg.getDspId()) + ";" + String.valueOf(advertId);
                dspComparePriceService.updateAdxAdvertCache(key);
            }
        }

    }

    @Override
    public void afterPropertiesSet() throws Exception {
        //在消息处理器中注册
        RocketMqMessageListener.registerCallback(this);
    }
}
