package cn.com.duiba.tuia.message.rocketmq.listener;

import cn.com.duiba.tuia.cache.MediaCacheService;
import cn.com.duiba.tuia.ssp.center.api.constant.RedisKeyConstant;
import cn.com.duiba.tuia.ssp.center.api.dto.MediaTagDto;
import com.alibaba.fastjson.JSON;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 接收媒体是否网赚标签变更消息
 */
@Component
public class RefreshAppEarnMoneyOnlineTagsCacheHandler extends AbstractMessageResultHandler {


    @Autowired
    private MediaCacheService mediaCacheService;
    @Override
    public String getListenTag() {
        return RedisKeyConstant.getTagRelationKey() + MediaTagDto.EMO_BLOCK;
    }

    @Override
    public void consumer(String message) {
        if (StringUtils.isNotBlank(message)) {
            logger.info("Topic:{},Msg:{}",getListenTag(),message);
            try {

                mediaCacheService.updateAppEmoBlockTags(JSON.parseObject(message, MediaTagDto.class).getAppId());
            } catch (Exception e) {
                logger.error("RefreshAppEarnMoneyOnlineTagsCacheHandler is error, message:{}", message, e);
            }
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        //在消息处理器中注册
        RocketMqMessageListener.registerCallback(this);
    }
}
