package cn.com.duiba.tuia.message.rocketmq.listener;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.com.duiba.tuia.cache.MediaCacheService;
import cn.com.duiba.tuia.ssp.center.api.constant.RedisKeyConstant;
import cn.com.duiba.tuia.ssp.center.api.dto.MediaTagDto;

import com.alibaba.fastjson.JSON;


@Component
public class RefreshAppIndustryTagsCacheHandler extends AbstractMessageResultHandler {


    @Autowired
    private MediaCacheService mediaCacheService;
    @Override
    public String getListenTag() {
        return RedisKeyConstant.getTagRelationKey().toString()+"1";
    }

    @Override
    public void consumer(String message) {
        if (StringUtils.isNotBlank(message)) {
            logger.info("Topic:{},Msg:{}",getListenTag(),message);
            mediaCacheService.updateAppIndustryTags(JSON.parseObject(message, MediaTagDto.class).getAppId());
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        //在消息处理器中注册
        RocketMqMessageListener.registerCallback(this);
    }
}
