package cn.com.duiba.tuia.message.rocketmq.listener;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.com.duiba.tuia.cache.ServiceManager;
import cn.com.duiba.tuia.ssp.center.api.constant.RedisKeyConstant;
import cn.com.duiba.tuia.ssp.center.api.dto.ActivityAdvertInfoWithParamDto;

import com.alibaba.fastjson.JSON;


@Component
public class RefreshBusinessActivityCacheHandler extends AbstractMessageResultHandler {


    @Autowired
    private ServiceManager serviceManager;
    @Override
    public String getListenTag() {
        return RedisKeyConstant.getActivityDirectAdvertKey().toString();
    }

    @Override
    public void consumer(String message) {
        if (StringUtils.isNotBlank(message)) {
            logger.info("Topic:{},Msg:{}",getListenTag(),message);
            ActivityAdvertInfoWithParamDto paramDto= JSON.parseObject(message, ActivityAdvertInfoWithParamDto.class);
            serviceManager.updateBusinessActivityCache(paramDto.getActivityId()+"-"+(paramDto.getSource()-1));
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        //在消息处理器中注册
        RocketMqMessageListener.registerCallback(this);
    }
}
