package cn.com.duiba.tuia.message.rocketmq.listener;

import cn.com.duiba.tuia.service.buildparam.SlotChooseAdvertService;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RefreshChooseAdvertCacheHandler extends AbstractMessageResultHandler {

    @Autowired
    private SlotChooseAdvertService slotChooseAdvertService;

    @Override
    public String getListenTag() {
        return "chooseAdvertRefreshTag";
    }

    @Override
    public void consumer(String message) {
        logger.info("chooseAdvertRefreshTag 刷新广告位数据，msg="+message);

        if (StringUtils.isBlank(message)) {
            return;
        }
        String[] splits = message.split(",");
        for (String split : splits) {
            try {
                Long slotId = Long.valueOf(split);
                this.slotChooseAdvertService.refreshData(slotId);
            } catch (Exception e) {
                logger.error("解析异常，msg="+message,e);
            }
        }

    }

    @Override
    public void afterPropertiesSet() throws Exception {
        //在消息处理器中注册
        RocketMqMessageListener.registerCallback(this);
    }
}
