package cn.com.duiba.tuia.message.rocketmq.listener;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

import cn.com.duiba.tuia.cache.AdvertCompensateCacheService;
import cn.com.tuia.advert.cache.RedisCommonKeys;

/**
 * 刷新广告赔付列表缓存
 *
 * @author peanut.huang
 * @date 2019/10/18
 * @since JDK 1.8
 */
@Component
public class RefreshCompensateListHandler extends AbstractMessageResultHandler {

    @Resource
    private AdvertCompensateCacheService advertCompensateCacheService;


    @Override
    public String getListenTag() {
       return RedisCommonKeys.KC142.toString();
    }

    /**
     * 消费消息
     *
     * @param message
     * @author zf
     * @since JDK 1.6
     */
    @Override
    public void consumer(String message) {
        logger.info("tags:{},Msg:{}", getListenTag(), message);
        if(StringUtils.isBlank(message)){
            return;
        }
        advertCompensateCacheService.refreshCompensateList(message);
    }


    @Override
    public void afterPropertiesSet() throws Exception {
        //在消息处理器中注册
        RocketMqMessageListener.registerCallback(this);
    }
}
