package cn.com.duiba.tuia.message.rocketmq.listener;

import cn.com.duiba.tuia.dao.dmp.DmpAdvertDAO;
import cn.com.duiba.tuia.domain.dataobject.DmpAdvertDO;
import cn.com.tuia.advert.constants.SystemConfigKeyConstant;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

@Component
public class RefreshDmpAdvertHandler extends AbstractMessageResultHandler{

    private static final String DMP_CACHE_KEY="dmp";

    @Autowired
    private DmpAdvertDAO dmpAdvertDAO;

    @Autowired
    private ExecutorService executorService;

    //有消息同步，不用设置过期时间来保证避免读取旧值
    private final LoadingCache<String,List<DmpAdvertDO>> DMP_ADVERTS = CacheBuilder.newBuilder().initialCapacity(1000).
            expireAfterWrite(5,TimeUnit.MINUTES).build(new CacheLoader<String, List<DmpAdvertDO>>() {
        @Override
        public List<DmpAdvertDO> load(String key) throws Exception {
            return dmpAdvertDAO.queryAllValidateDmpAdvert();
        }

        @Override
        public ListenableFuture<List<DmpAdvertDO>> reload(String key, List<DmpAdvertDO> oldValue) throws Exception {
            ListenableFutureTask<List<DmpAdvertDO>> task = ListenableFutureTask.create(new Callable<List<DmpAdvertDO>>() {
                public List<DmpAdvertDO> call() throws Exception {
                    return load(key);
                }
            });
            executorService.submit(task);
            return task;
        }
    });

    @Override
    public String getListenTag() {
        return SystemConfigKeyConstant.DPM_TEST_DATA;
    }

    @Override
    public void consumer(String message) {
        try{
            if (StringUtils.isNotBlank(message)) {
                DMP_ADVERTS.put(DMP_CACHE_KEY,dmpAdvertDAO.queryAllValidateDmpAdvert());
                logger.info("dmpAdvert:{}",message);
            }
        }catch (Exception e){
            logger.error("获取Dmp测试广告异常！");
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        RocketMqMessageListener.registerCallback(this);
    }

    public List<DmpAdvertDO> getDmpAdverts() {
        try {
            return DMP_ADVERTS.get(DMP_CACHE_KEY);
        } catch (Exception e) {
            logger.error("获取dmp测试广告异常！");
            return Collections.emptyList();
        }
    }
}
