package cn.com.duiba.tuia.message.rocketmq.listener;

import cn.com.duiba.tuia.constants.AdvertSystemConfigureConstants;
import cn.com.duiba.tuia.dao.engine.SystemConfigDAO;
import cn.com.tuia.advert.constants.SystemConfigKeyConstant;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RefreshDmpSwitchHandler extends AbstractMessageResultHandler{

    @Autowired
    private SystemConfigDAO systemConfigDAO;

    @Override
    public String getListenTag() {
        return SystemConfigKeyConstant.DPM_DATA_OPEN;
    }

    @Override
    public void consumer(String message) {
        try{
            if (StringUtils.isNotBlank(message)) {
                AdvertSystemConfigureConstants.dmpSwitch = Boolean.valueOf(message);
                logger.info("dmpSwitch:{}",AdvertSystemConfigureConstants.dmpSwitch);
            }
        }catch (Exception e){
            logger.error("获取DMP开关异常！");
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        RocketMqMessageListener.registerCallback(this);
    }
}
