package cn.com.duiba.tuia.message.rocketmq.listener;

import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.com.duiba.tuia.cache.AdvertMapCacheManager;
import cn.com.tuia.advert.constants.RocketMqCommonkeys;

import com.alibaba.fastjson.JSON;

/**刷新广告位缓存
 * Created by jzl on 18/4/18.
 */
@Component
public class RefreshGlobalFlowConfigMsgHandler extends AbstractMessageResultHandler {

    @Autowired
    private AdvertMapCacheManager advertMapCacheManager;

    @Override
    public String getListenTag() {
        return RocketMqCommonkeys.GLOBAL_FLOW_CONFIG_MSG;
    }

    @Override
    public void consumer(String message) {
        if (StringUtils.isBlank(message)) {
            return;
        }
        logger.info("Topic:{},Msg:{}",getListenTag(),message);
        List<String> refreshIds = JSON.parseArray(message, String.class);
        
        for (int i = 0; i < refreshIds.size(); i++) {
            try {
                advertMapCacheManager.updateValidPkgFilterCache(refreshIds.get(i));
                if (i % 10 == 0) {
                    Thread.sleep(500L);
                }
            } catch (Exception e) {
                logger.error("updateValidPkgFilterCache error, id=[{}],", refreshIds.get(i) , e);
                
            }
            
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        //在消息处理器中注册
        RocketMqMessageListener.registerCallback(this);
    }
}
