package cn.com.duiba.tuia.message.rocketmq.listener;

import cn.com.duiba.tuia.cache.LowArpuCacheService;
import cn.com.tuia.advert.constants.RocketMqCommonkeys;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RefreshLowArpuWhiteHandler extends AbstractMessageResultHandler {


    @Autowired
    private LowArpuCacheService lowArpuCacheService;

    @Override
    public String getListenTag() {
        return RocketMqCommonkeys.LOW_ARPU_WHITE;
    }

    @Override
    public void consumer(String message) {
        logger.info("refreshLowArpuWhiteHandler consumer:{}", message);
        lowArpuCacheService.refreshLowArpuWhite();
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        RocketMqMessageListener.registerCallback(this);
    }
}
